#ifndef WINXY_H
#define WINXY_H

#include <QMainWindow>
#include <QStackedWidget>
#include <QPushButton>
#include <QList>
#include <QVBoxLayout>
#include <QString>
#include <QDir>

QT_BEGIN_NAMESPACE
namespace Ui { class WinXY; }
QT_END_NAMESPACE

// =============================================================================
// [NEW] Global Configuration & Resource Discovery Class
// =============================================================================
class AppConfig
{
public:
    // Call this once in main.cpp before loading UI
    static void initialize();

    // Returns the discovered project root directory
    static QString getRootDir();

    // Helper: Returns full path to a file inside the "figures" folder
    static QString getAssetPath(const QString &fileName);

    // Helper: Returns full path to the "rule.json" config file
    static QString getRuleJsonPath();

private:
    static QString m_rootDir;
};

// =============================================================================
// Main Window Class
// =============================================================================
class WinXY : public QMainWindow
{
    Q_OBJECT

public:
    WinXY(QWidget *parent = nullptr);
    ~WinXY();

    void addFeature(QWidget *pageWidget, const QString &tabName);

private slots:
    void onTabClicked();

private:
    Ui::WinXY *ui;

    QStackedWidget *mainContentStack;
    QWidget *sidebarContainer;
    QVBoxLayout *sidebarLayout;

    QList<QPushButton*> sidebarTabs;

    QPushButton* createSidebarButton(const QString &text);
    void updateTabStyles(int activeIndex);
};

#endif // WINXY_H
